import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getRecord,
  getListingData,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
} from "../helper/general.js";
import ShiftInformation from "../sequelize/ShiftInformationSchema.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/** Function to create or update ShiftInformation */
export const createUpdateShiftInformation = async (req, res) => {
  const { id, name, description, organization } = req.body;
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "ShiftInformation",
      "shift_information",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "shift_information",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "ShiftInformation name already exist");
    } else if (!id) {
      return sendResponse(
        res,
        400,
        "ShiftInformation name name  already exist"
      );
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(ShiftInformation, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "ShiftInformation",
      id
    );
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(ShiftInformation, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "ShiftInformation",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // if (id) {
  //   const result = await settingsUpdater(
  //     ShiftInformation,
  //     req.body.organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }
  //   await insertActivityLog(req.user.sessionid, "update", "ShiftInformation", `This user updated ShiftInformation with id: ${id}`);
  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const insertPromises = req.body.organization.map(async (org) => {
  //     const [checkName] = await db.query(`SELECT name FROM shift_information WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
  //     if (checkName.length === 0) {
  //       const unique_id = await uniqueIdGenerator(
  //         org,
  //         req?.body?.department,
  //         "SI",
  //         "shift_information",
  //         "unique_id",
  //         "unique_id"
  //       );
  //       await db.query(`INSERT INTO shift_information (name, description, created_by, organization,unique_id) VALUES (?, ?,?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org,unique_id]);
  //       await insertActivityLog(req.user.sessionid, "create", "ShiftInformation", `This user created a new ShiftInformation '${name}' for organization ${org}`);
  //     }
  //   });
  //   await Promise.all(insertPromises);
  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/** Function to view all or single ShiftInformation */
export const viewShiftInformation = async (req, res) => {
  
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "shift_information"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "shift_information.name",
    "shift_information.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = shift_information.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let shiftInformationQuery = `SELECT 
  shift_information.*, 
  shift_information.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM shift_information
${joinsRecord} 
WHERE shift_information.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [shiftInformation] = await db.query(shiftInformationQuery);
  shiftInformation = await getListingData(shiftInformation);
  /**Count all organization */
  const totalRecord = await countQueryCondition(shiftInformationQuery);
  return sendResponse(res, 200, shiftInformation, totalRecord);

  
  
  
  
  
  
  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "shift_information",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchFields = [
  //   "shift_information.name",
  //   "shift_information.description",
  //   "users.name",
  //   "organization.name",
  // ];
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchFields
  // );
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = shift_information.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = shift_information.organization",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const fetchQuery = `SELECT shift_information.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM shift_information ${joinsRecord} WHERE shift_information.deleted = 0 ${searchCondition} ${condition}`;
  // let [records] = await db.query(fetchQuery);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM shift_information WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  // const totalRecord = await countQueryCondition(fetchQuery);
  // return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete ShiftInformation */
export const deleteShiftInformation = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("shift_information", id);
  if (deleteRecord) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "ShiftInformation",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
