import db from "../db-config.js";
import {
  countQueryCondition,
  deleteSettingRecord,
  makeJoins,
  searchConditionRecord,
  whereCondition,
} from "../helper/general.js";
import Sidebar from "../sequelize/SidebarSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import { sidebarSchema } from "../validationsRecord/validationSchema.js";

/**Function to create new Sidebar for employee  */
export const createUpdateSidebar = async (req, res) => {
  const { id } = req.body;
  const { error } = sidebarSchema.validate(req.body);
  if (error) {
    return sendResponse(res, 400, error.details[0].message);
  }
  /**If id comes in body then it will update the query */
  if (id) {
    const { query, value } = updateQueryBuilder(Sidebar, req.body);
    const [result] = await db.query(query, value);
    if (result.affectedRows == 0) {
      return sendResponse(res, 404, "No data found");
    }
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    /** Insert new record */
    const { query, value } = insertQueryBuilder(Sidebar, req.body);
    const [result] = await db.query(query, value);
    return sendResponse(res, 200, "Record created successfully");
  }
};
/** Function to view all and single Sidebar using recursion */
export const viewSidebar = async (req, res) => {
  const { id } = req.params;
  const filterObj = JSON.parse(req.query?.filter || "{}");
  const dependent_module = filterObj?.dependent_module;
  const parentFilter = dependent_module
    ? `AND sidebar.parent_id = ${dependent_module}`
    : "";
  const searchTableName = ["sidebar.title"];

  /** If value comes with any search condition then search that word */
  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /** Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "sidebar as s2",
      onCondition: "sidebar.id = sidebar.parent_id",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  // Recursive function to fetch all children
  const fetchChildren = async (parentIds) => {
    if (!parentIds || parentIds.length === 0) return [];

    const SidebarChildQuery = `
      SELECT sidebar.*, s2.id as parent_id, s2.title as parent_title 
      FROM sidebar ${joinsRecord}
      WHERE sidebar.deleted = 0 
        AND sidebar.parent_id IN (${parentIds.join(",")})
        AND sidebar.path IS NOT NULL
    `;

    const [SidebarChildRecord] = await db.query(SidebarChildQuery);

    if (SidebarChildRecord.length === 0) return [];

    const childIds = SidebarChildRecord.map((item) => item.id);
    const deeperChildren = await fetchChildren(childIds);

    return [...SidebarChildRecord, ...deeperChildren];
  };

  // Initial query to get the top-level sidebars
  const SidebarQuery = `
    SELECT sidebar.*, s2.id as parent_id, s2.title as parent_title 
    FROM sidebar ${joinsRecord}
    WHERE sidebar.deleted = 0 
      ${searchCondition} 
      ${parentFilter}
  `;

  const [SidebarRecord] = await db.query(SidebarQuery);

  // Extract the initial IDs to fetch children
  const ids = SidebarRecord.map((item) => item.id);

  // Recursively fetch all child sidebars
  const allChild = await fetchChildren(ids);

  return sendResponse(res, 200, allChild);
};

/**Function to delete a specific Sidebar */
export const deleteSidebar = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("sidebar", id);
  return sendResponse(res, 200, "Record deleted successfully");
};
