import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateAssetType, deleteAssetType, viewAssetType } from "../controller/assetTypeController.js";

/**
 * @swagger
 * tags:
 *   name:  asset type
 *   description: API operations for managing  asset type
 */
const assetTypeRoutes = Router();

/**
 * @swagger
 * /api/assetType/create-update-asset-type:
 *   post:
 *     summary: Create or update a  asset type
 *     tags: [ asset type]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
assetTypeRoutes.post(
  "/create-update-asset-type",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 387, "asset_type")(req, res, next);
  },
  controllerWrapper(createUpdateAssetType)
);

/**
 * @swagger
 * /api/assetType/get-asset-type:
 *   get:
 *     summary: Get all records of  asset type
 *     tags: [ asset type]
 */
assetTypeRoutes.get(
  "/get-asset-type",
  verifyToken,
  sideBarPermissionCheck("view", 387, "asset_type"),
  controllerWrapper(viewAssetType)
);

/**
 * @swagger
 * /api/assetType/get-asset-type/{id}:
 *   get:
 *     summary: Get a specific record of  asset type
 *     tags: [ asset type]
 */
assetTypeRoutes.get(
  "/get-asset-type/:id",
  verifyToken,
  sideBarPermissionCheck("view", 387, "asset_type"),
  controllerWrapper(viewAssetType)
);

/**
 * @swagger
 * /api/assetType/delete-asset-type/{id}:
 *   delete:
 *     summary: Delete a specific record of  asset type
 *     tags: [ asset type]
 */
assetTypeRoutes.delete(
  "/delete-asset-type/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 387, "asset_type"),
  controllerWrapper(deleteAssetType)
);

export default assetTypeRoutes;
