// Import necessary modules
import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  viewAllAuditLog,
} from "../controller/auditLogController.js";
import { controllerWrapper } from "../helper/wrapper.js";
 
 

/**
 * @swagger
 * tags:
 *   name: Audit Log
 *   description: API operations for managing all Audit Log
 */
const auditLogRoutes = Router();



/**
 * @swagger
 * /api/auditLog/get-audit-log:
 *   get:
 *     summary: Get a list of all Audit Log
 *     tags: [Audit Log]
 */
auditLogRoutes.get(
  "/get-audit-log",
  verifyToken,
  sideBarPermissionCheck("view", 397, "audit_log"),
  controllerWrapper(viewAllAuditLog)
);
 

export default auditLogRoutes;
