import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateCrisisLocation, deleteCrisisLocation, viewCrisisLocation } from "../controller/crisisLocationController.js";

/**
 * @swagger
 * tags:
 *   name:  crisis location
 *   description: API operations for managing  crisis location
 */
const crisisLocationRoutes = Router();

/**
 * @swagger
 * /api/crisisLocation/create-update-crisis-location:
 *   post:
 *     summary: Create or update a  crisis location
 *     tags: [ crisis location]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
crisisLocationRoutes.post(
  "/create-update-crisis-location",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 440 , "crisis_location")(req, res, next);
  },
  controllerWrapper(createUpdateCrisisLocation)
);

/**
 * @swagger
 * /api/crisisLocation/get-crisis-location:
 *   get:
 *     summary: Get all records of  crisis location
 *     tags: [ crisis location]
 */
crisisLocationRoutes.get(
  "/get-crisis-location",
  verifyToken,
  sideBarPermissionCheck("view", 440, "crisis_location"),
  controllerWrapper(viewCrisisLocation)
);

/**
 * @swagger
 * /api/crisisLocation/get-crisis-location/{id}:
 *   get:
 *     summary: Get a specific record of  crisis location
 *     tags: [ crisis location]
 */
crisisLocationRoutes.get(
  "/get-crisis-location/:id",
  verifyToken,
  sideBarPermissionCheck("view", 440, "crisis_location"),
  controllerWrapper(viewCrisisLocation)
);

/**
 * @swagger
 * /api/crisisLocation/delete-crisis-location/{id}:
 *   delete:
 *     summary: Delete a specific record of  crisis location
 *     tags: [ crisis location]
 */
crisisLocationRoutes.delete(
  "/delete-crisis-location/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 440, "crisis_location"),
  controllerWrapper(deleteCrisisLocation)
);

export default crisisLocationRoutes;