import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateEngagementMethod,
  deleteEngagementMethod,
  viewEngagementMethod,
} from "../controller/engagementMethodController.js";

/**
 * @swagger
 * tags:
 *   name:  engagement method
 *   description: API operations for managing  engagement method
 */
const engagementMethodRoutes = Router();

/**
 * @swagger
 * /api/engagementMethod/create-update-engagement-method:
 *   post:
 *     summary: Create or update a  engagement method
 *     tags: [ engagement method]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
engagementMethodRoutes.post(
  "/create-update-engagement-method",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(
      req.body.id ? "edit" : "create",
      13,
      "engagement_method"
    )(req, res, next);
  },
  controllerWrapper(createUpdateEngagementMethod)
);

/**
 * @swagger
 * /api/engagementMethod/get-engagement-method:
 *   get:
 *     summary: Get all records of  engagement method
 *     tags: [ engagement method]
 */
engagementMethodRoutes.get(
  "/get-engagement-method",
  verifyToken,
  controllerWrapper(viewEngagementMethod)
);

/**
 * @swagger
 * /api/engagementMethod/get-engagement-method/{id}:
 *   get:
 *     summary: Get a specific record of  engagement method
 *     tags: [ engagement method]
 */
engagementMethodRoutes.get(
  "/get-engagement-method/:id",
  verifyToken,
  controllerWrapper(viewEngagementMethod)
);

/**
 * @swagger
 * /api/engagementMethod/delete-engagement-method/{id}:
 *   delete:
 *     summary: Delete a specific record of  engagement method
 *     tags: [ engagement method]
 */
engagementMethodRoutes.delete(
  "/delete-engagement-method/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 13, "engagement_method"),
  controllerWrapper(deleteEngagementMethod)
);

export default engagementMethodRoutes;
