import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdatePpeType,
  deletePpeType,
  viewPpeTypeDropDown,
  viewPpeType,
  getParentPpeTypeList,
} from "../controller/ppeTypeController.js";

/**
 * @swagger
 * tags:
 *   name: PpeType
 *   description: API operations for managing PpeType
 */
const ppeTypeRoutes = Router();

/**
 * @swagger
 * /api/ppe-type/create-update-ppe-type:
 *   post:
 *     summary: Create or update a PpeType
 *     tags: [PpeType]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
ppeTypeRoutes.post(
  "/create-update-ppe-type",
  verifyToken,
  // (req, res, next) => {
  //   sideBarPermissionCheck(req.body.id ? "edit" : "create", 365 , "ppe-type")(req, res, next);
  // },
  controllerWrapper(createUpdatePpeType)
);

/**
 * @swagger
 * /api/ppe-type/get-ppe-type:
 *   get:
 *     summary: Get all records of PpeType
 *     tags: [PpeType]
 */
ppeTypeRoutes.get(
  "/get-ppe-type",
  verifyToken,
  sideBarPermissionCheck("view", 365, "ppe-type"),
  controllerWrapper(viewPpeType)
);

/**
 * @swagger
 * /api/ppe-type/get-ppe-type/{id}:
 *   get:
 *     summary: Get a specific record of PpeType
 *     tags: [PpeType]
 */
ppeTypeRoutes.get(
  "/get-ppe-type/:id",
  verifyToken,
  sideBarPermissionCheck("view", 365, "ppe-type"),
  controllerWrapper(viewPpeType)
);

/**
 * @swagger
 * /api/ppe-type/delete-ppe-type/{id}:
 *   delete:
 *     summary: Delete a specific record of PpeType
 *     tags: [PpeType]
 */
ppeTypeRoutes.delete(
  "/delete-ppe-type/:id",
  verifyToken,
  controllerWrapper(deletePpeType)
);
/**
 * @swagger
 * /api/ppe-type/delete-ppe-type/{id}:
 *   get:
 *     summary: Get the list for selecting parent category
 *     tags: [PpeType]
 *     parameters:
 *       - in: query
 *         organization : [1,2,34,4]
 *         schema:
 *           type: Array
 *         description: Array of organization to fetch the list
 */

ppeTypeRoutes.get(
  "/get-ppe-type-list",
  verifyToken,
  controllerWrapper(getParentPpeTypeList)
);

/**
 * @swagger
 * /api/ppe-type/get-ppe-type-dropdown:
 *   get:
 *     summary: Get the list all PpeType
 *     tags:
 *       - PpeType
 *     description: The ppe-type
 *     responses:
 *       200:
 *         description: PpeType data
 *       404:
 *         description: PpeType not found
 *       500:
 *         description: Internal server error
 */

ppeTypeRoutes.get(
  "/get-ppe-type-dropdown",
  verifyToken,
  // sideBarPermissionCheck("view", 365, "disability"),
  controllerWrapper(viewPpeTypeDropDown)
);
export default ppeTypeRoutes;
