import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateSecurityIncidentType,
  deleteSecurityIncidentType,
  viewSecurityIncidentType,
} from "../controller/securityIncidentTypeController.js";

/**
 * @swagger
 * tags:
 *   name:  security incident type
 *   description: API operations for managing  security incident type
 */
const securityIncidentTypeRoutes = Router();

/**
 * @swagger
 * /api/securityIncidentType/create-update-security-incident-type:
 *   post:
 *     summary: Create or update a  security incident type
 *     tags: [ security incident type]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
securityIncidentTypeRoutes.post(
  "/create-update-security-incident-type",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(
      req.body.id ? "edit" : "create",
      405,
      "security_incident_type"
    )(req, res, next);
  },
  controllerWrapper(createUpdateSecurityIncidentType)
);

/**
 * @swagger
 * /api/securityIncidentType/get-security-incident-type:
 *   get:
 *     summary: Get all records of  security incident type
 *     tags: [ security incident type]
 */
securityIncidentTypeRoutes.get(
  "/get-security-incident-type",
  verifyToken,
  sideBarPermissionCheck("view", 405, "security_incident_type"),
  controllerWrapper(viewSecurityIncidentType)
);

/**
 * @swagger
 * /api/securityIncidentType/get-security-incident-type/{id}:
 *   get:
 *     summary: Get a specific record of  security incident type
 *     tags: [ security incident type]
 */
securityIncidentTypeRoutes.get(
  "/get-security-incident-type/:id",
  verifyToken,
  sideBarPermissionCheck("view", 405, "security_incident_type"),
  controllerWrapper(viewSecurityIncidentType)
);

/**
 * @swagger
 * /api/securityIncidentType/delete-security-incident-type/{id}:
 *   delete:
 *     summary: Delete a specific record of  security incident type
 *     tags: [ security incident type]
 */
securityIncidentTypeRoutes.delete(
  "/delete-security-incident-type/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 405, "security_incident_type"),
  controllerWrapper(deleteSecurityIncidentType)
);

export default securityIncidentTypeRoutes;
