import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import AuditScheduling from "./AuditSchedulingSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import Repository from "./RepositorySchema.js";

const AuditExecution = sequelize.define(
  "AuditExecution",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    scheduled_audit: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // references: {
      //   model: AuditScheduling,
      //   key: "id",
      // },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    evaluation_tool_status: {
      type: DataTypes.STRING(255),
    },
    actual_audit_start_date_time: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    actual_audit_end_date_time: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    audit_protocol: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    audit_execution_id: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    // report: {
    //   type: DataTypes.TEXT("long"),
    // },

    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "audit_execution",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// AuditExecution.belongsTo(AuditScheduling, {
//   as: "scheduledAudit",
//   foreignKey: "scheduled_audit",
// });
AuditExecution.belongsTo(Organization, {
  as: "org",
  foreignKey: "organization",
});
AuditExecution.belongsTo(Department, { as: "dept", foreignKey: "department" });
AuditExecution.belongsTo(User, { as: "creator", foreignKey: "created_by" });
AuditExecution.belongsTo(User, { as: "updater", foreignKey: "updated_by" });

// console.log(await AuditExecution.sync({ alter: true }));
export default AuditExecution;
