import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import ContractorPreSite from "./ContractorPreSiteSchema.js";

const ContractorPreSiteDocs = sequelize.define(
  "ContractorPreSiteDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    pre_site_response_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorPreSite,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "contractor_pre_site_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

export default ContractorPreSiteDocs;
