import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const FeedbackCollectionMethod = sequelize.define(
  "FeedbackCollectionMethod",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    method_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    method_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    review_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    collection_method_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    target_stakeholder: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    frequency: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    responsible_person: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "feedback_collection",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

FeedbackCollectionMethod.belongsTo(User, {
  foreignKey: "responsible_person",
  as: "ResponsiblePerson",
});
FeedbackCollectionMethod.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
FeedbackCollectionMethod.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
FeedbackCollectionMethod.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
FeedbackCollectionMethod.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

export default FeedbackCollectionMethod;
