import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import FinalHandoverResponses from "./FinalHandoverResponsesSchema.js";

const FinalHandoverResponseDocs = sequelize.define(
  "FinalHandoverResponseDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    final_handover_response_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "final_handover_responses_docs",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Define association and specify the foreign key constraint name
FinalHandoverResponseDocs.belongsTo(FinalHandoverResponses, {
  foreignKey: {
    name: "fk_handover_response_id", // Shorter name for the foreign key constraint
    field: "final_handover_response_id",
    allowNull: true,
  },
  as: "handoverResponse", // Alias for the association
});

// console.log(await FinalHandoverResponseDocs.sync({ alter: true }));
export default FinalHandoverResponseDocs;
