import ContractorRegistration from "./ContractorRegistrationSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import PermitLicenseCompliance from "./PermitLicenseComplianceSchema.js";
import Severity from "./SeveritySchema.js";
import IncidentLocation from "./IncidentLocationSchema.js";

const Incident = sequelize.define(
  "Incident",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    incident_category: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      //example: [1, 2, 3, 4] : reference {IncidentCategory Table}
    },
    incident_title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    incident_reporting_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    incident_actual_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    incident_actual_time: {
      type: DataTypes.TIME(6),
      allowNull: true,
    },
    initial_incident_severity: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Severity,
        key: "id",
      },
    },
    incident_location: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    reference_no: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    specify: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    // is_contractor: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   defaultValue: 0,
    // },
    // contractor: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    //   // references: {
    //   //   model: ContractorRegistration,
    //   //   key: "id",
    //   // },
    //   //onUpdate: "CASCADE",
    //   //onDelete: "SET NULL",
    //   //example : [{"contractor": 1, "project": 1, "incident_role": 1}]
    // },
    // project:{
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   references: {
    //     model: ProjectRegistration,
    //     key: "id",
    //   },
    //   //onUpdate: "CASCADE",
    //   //onDelete: "SET NULL",
    // },
    // incident_role:{
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   references: {
    //     model: IncidentRole,
    //     key: "id",
    //   },
    //   //onUpdate: "CASCADE",
    //   //onDelete: "SET NULL",
    // },
    // "photographs_incident": [
    //     {
    //         "id": "",
    //         "title": "hello1",
    //         "file": {},
    //         "file_classification": 1
    //     },
    //     {
    //         "id": "",
    //         "title": "hello2",
    //         "file": {},
    //         "file_classification": 1
    //     }
    // ],
    save_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
      // example: "draft"(only),
    },
    current_impact: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    potential_impact: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    person_type: {
      type: DataTypes.ENUM("Internal", "External", "Both"),
      allowNull: true,
      defaultValue: "Internal",
    },
    // internal_persons: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    //   //example:[{"user_id": 1, "incident_role": 1}]
    // },
    // external_persons: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    //   //example:[{"contractor_id": 1, "project_id": 1, "is_contractor": (1 or 0)," "incident_role": 1}]
    // },
    incident_persons_involved: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    was_the_person_licensed: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
    },
    permit_license: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: PermitLicenseCompliance,
        key: "id",
      },
    },
    incident_reporting_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    is_done: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },
    notification: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      //example: [{ "user_id": 1, "role": 1}]
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "incident",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

Incident.belongsTo(User, {
  foreignKey: "incident_reporting_by",
  as: "Reporter",
});
Incident.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
Incident.belongsTo(Department, { foreignKey: "department", as: "Department" });
Incident.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "Contractor",
});
Incident.belongsTo(PermitLicenseCompliance, {
  foreignKey: "permit_license",
  as: "PermitLicense",
});
// console.log(await Incident.sync({ alter: true }));
export default Incident;
