import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Investigation from "./InvestigationSchema.js";
import InsuranceClaim from "./InsuranceClaimRecordingSchema.js";
import Repository from "./RepositorySchema.js";

const InsuranceClaimDocs = sequelize.define(
  "InsuranceClaimDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    insurance_claim_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: InsuranceClaim,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "insurance_claim_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

InsuranceClaimDocs.belongsTo(InsuranceClaim, {
  foreignKey: "insurance_claim_id",
  as: "InsuranceClaim",
});
// console.log(await InsuranceClaimDocs.sync({ alter: true }));

export default InsuranceClaimDocs;
