import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Meeting from "./MeetingSchema.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const MeetingRecording = sequelize.define(
  "MeetingRecording",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    scheduled_meeting: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Meeting,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    actual_meeting_date_from: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    actual_meeting_date_to: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    meeting_duration: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    meeting_scriber: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    // actions:{
    //   type:DataTypes.TEXT("long"),
    //   allowNull:true
    // },
    discussion_have_action:{
      type: DataTypes.INTEGER,
      defaultValue:0
    },
    participants: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    meeting_notes: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("New", "Pending", "Approved", "Rejected"),
      defaultValue: "New",
    },
    comment: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    external_guest_details: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    external_meeting_guest: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "meeting_recording",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

MeetingRecording.belongsTo(Meeting, {
  foreignKey: "scheduled_meeting",
  as: "ScheduledMeeting",
});
MeetingRecording.belongsTo(User, {
  foreignKey: "meeting_scriber",
  as: "MeetingScriber",
});
MeetingRecording.belongsTo(User, { foreignKey: "created_by", as: "CreatedBy" });
MeetingRecording.belongsTo(User, { foreignKey: "updated_by", as: "UpdatedBy" });
MeetingRecording.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
MeetingRecording.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
// console.log(await MeetingRecording.sync({ alter: true }));
export default MeetingRecording;
