import { Model, DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import PpeType from "./PpeTypeSchema.js";
import Location from "./LocationSchema.js";
import Department from "./DepartmentSchema.js";

class PPERepository extends Model {}

PPERepository.init(
  {
    effective_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    last_inspection_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    inspection_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    location: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Location,
        key: "id",
      },
    },
    next_inspection_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    scheduled_status: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: "Pending",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
    },
    quantity: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    review_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    type: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // references:{
      //   model: PpeType,
      //   key: "id",
      // }
    },
    // added new fields
    name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    currency: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    inspection_outcome: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    investigation_outcome: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    maintenance_frequency: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    maintenance_provider: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    ogdptype: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    root_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    immediate_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    inspection_checklist: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    schedule: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    action_taken: {
      type: DataTypes.INTEGER,
      allowNull: true,
      //reference:{Custom Action Creation Table}
    },
    // task_data: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    value: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    content_list: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: "id",
      },
    },
    updated_by: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: "id",
      },
    },
  },
  {
    modelName: "PPERepository",
    tableName: "ppe_repository",
    sequelize,
    timestamps: true,
    underscored: true,
  }
);
// console.log(await PPERepository.sync({ alter: true }));

export default PPERepository;
