import sequelize from "./sequelize.js";
import { Model, DataTypes } from "sequelize";
import User from "./UserSchema.js";

class PoliceStation extends Model {}

PoliceStation.init(
  {
    name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    city_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    
    is_static: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: User.primaryKeyAttribute,
      },
      allowNull: true,
    },
    updated_by: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: User.primaryKeyAttribute,
      },
    },
    deleted: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
      allowNull: true,
    },
  },
  {
    tableName: "police_station",
    timestamps: true,
    createdAt: "created_at",
    updatedAt: "updated_at",
    sequelize,
  }
);
// console.log(await PoliceStation.sync({alter:true}));
export default PoliceStation;
