import ContractorRegistration from "./ContractorRegistrationSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import TypeOfService from "./TypeOfServiceSchema.js";

const ProjectRegistration = sequelize.define(
  "ProjectRegistration",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    cipc_registration_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    site_address: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    access_location: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    project_title: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    project_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    type_of_work: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: TypeOfService,
        key: "id",
      },
    },
    project_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    project_end_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    reason: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    project_planned_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    actual_end_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    contract_reference_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    contract_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    contract_end_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    project_value: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    contract_value: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    currency: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    classification_value: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    classification_criticality: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    classification_impact: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    classification_category: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    project_members: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    sub_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    sub_contractors_personnel: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
  },
  {
    tableName: "project_registration",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ProjectRegistration.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "ContractorRegistration",
});
ProjectRegistration.belongsTo(ContractorRegistration, {
  foreignKey: "sub_contractor",
  as: "SubContractorRegistration",
});

ProjectRegistration.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

ProjectRegistration.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

ProjectRegistration.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

ProjectRegistration.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});
// console.log(await ProjectRegistration.sync({ alter: true }));
export default ProjectRegistration;
