import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const RoleOnTheProject = sequelize.define(
  "RoleOnTheProject",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.TEXT("long"),
      allowNull: true,

      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "role_on_the_project",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

RoleOnTheProject.belongsTo(Department, {
  as: "departmentDetails",
  foreignKey: "department",
});
// RoleOnTheProject.belongsTo(Organization, {
//   as: "organizationDetails",
//   foreignKey: "organization",
// });
RoleOnTheProject.belongsTo(User, {
  as: "creator",
  foreignKey: "created_by",
});
RoleOnTheProject.belongsTo(User, {
  as: "updater",
  foreignKey: "updated_by",
});
// console.log(await RoleOnTheProject.sync({ alter: true }));
export default RoleOnTheProject;
