import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import Meeting from "./MeetingSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const StrategicRisk = sequelize.define(
  "StrategicRisk",
  {
    id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      autoIncrement: true,
      primaryKey: true,
    },
    risk_register_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    assessment_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    review_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    risk_context: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    risk_assessment_facilitator: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    register_assessment_facilitator: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    risk_register_approver: {
      type: DataTypes.INTEGER,
      allowNull: true,
      comment: "risk_register_approver",
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    meeting_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Meeting,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    venue: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    time: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    attendance_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    attendees: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    reference_no: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "Draft",
    },
    approval_status: {
      type: DataTypes.ENUM("Pending Approval", "Approved", "Rejected"),
      allowNull: true,
      defaultValue: "Pending Approval",
    },
    reject_comment: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "strategic_risk",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

StrategicRisk.belongsTo(User, {
  foreignKey: "risk_assessment_facilitator",
  as: "RiskAssessmentFacilitator",
});

StrategicRisk.belongsTo(User, {
  foreignKey: "register_assessment_facilitator",
  as: "RegisterAssessmentFacilitator",
});

StrategicRisk.belongsTo(User, {
  foreignKey: "risk_register_approver",
  as: "RiskRegisterApprover",
});

StrategicRisk.belongsTo(Meeting, {
  foreignKey: "meeting_id",
  as: "Meeting",
});

StrategicRisk.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

StrategicRisk.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

StrategicRisk.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

StrategicRisk.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await StrategicRisk.sync({ alter: true }));
export default StrategicRisk;
