import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import SurveyDesign from "./SurveyDesignSchema.js";
import User from "./UserSchema.js";

const SurveyResponse = sequelize.define(
  "SurveyResponse",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    survey_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: null,
      references: {
        model: SurveyDesign,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: null,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    name: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: null,
    },
    email: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: null,
    },
    phone: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue: null,
    },
    response_values: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      defaultValue: null,
    },
    total: {
      type: DataTypes.BIGINT,
      allowNull: true,
      defaultValue: 0,
    },
    label: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: null,
    },
    is_internal: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    otp: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: null,
    },
    otp_expiry: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      defaultValue: null,
    },
    start_end: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: null,
    },
    is_declared: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "survey_response",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

SurveyResponse.belongsTo(SurveyDesign, {
  foreignKey: "survey_id",
  as: "SurveyDesign",
});

SurveyResponse.belongsTo(User, {
  foreignKey: "user_id",
  as: "User",
});

export default SurveyResponse;
