import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import TrainingNeedAnalysis from "./TrainingNeedAnalysisSchema.js";
import User from "./UserSchema.js";

const TrainingComments = sequelize.define(
  "TrainingComments",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    training_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: TrainingNeedAnalysis,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
  },
  {
    tableName: "training_comments",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

TrainingComments.belongsTo(TrainingNeedAnalysis, {
  foreignKey: "training_id",
  as: "TrainingNeedAnalysis",
});

TrainingComments.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

TrainingComments.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});

export default TrainingComments;
