import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import FireEquipmentRegister from "./FireEquipmentRegisterSchema.js";
const FireEquipmentStatusHistory = sequelize.define(
  "FireEquipmentStatusHistory",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },

    equipment_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    maintenance_inspection_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    updated_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    changed_fields: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    message: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    action: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    reported_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    notify_to: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    tableName: "fire_equipment_status_history",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
FireEquipmentStatusHistory.belongsTo(Department, {
  as: "DepartmentDetails",
  foreignKey: "department",
});

FireEquipmentStatusHistory.belongsTo(Organization, {
  as: "OrganizationDetails",
  foreignKey: "organization",
});

FireEquipmentStatusHistory.belongsTo(FireEquipmentRegister, {
  as: "Equipment",
  foreignKey: "equipment_id",
});

// console.log(await FireEquipmentStatusHistory.sync({ alter: true }));

export default FireEquipmentStatusHistory;
